<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exsl="http://exslt.org/common" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:rpr="relativePathResolverPrefix">
	<xsl:param name="outdir"/>
	<xsl:param name="navigation"></xsl:param>
	<xsl:param name="images"></xsl:param>

	<xsl:param name="scope_param"></xsl:param>
	<xsl:param name="root_element_name_param"></xsl:param>
	
	<!-- Options params -->
	<xsl:param name="tree_param"></xsl:param>
	<xsl:param name="index_param"></xsl:param>
	<xsl:param name="use_param"></xsl:param>
	<xsl:param name="help_param"></xsl:param>
	<xsl:param name="navbar_param"></xsl:param>
	<xsl:param name="split_param"></xsl:param>

	<xsl:param name="title_param"></xsl:param>
	<xsl:param name="doctitle_param"></xsl:param>
	<xsl:param name="header_param"></xsl:param>
	<xsl:param name="footer_param"></xsl:param>
	<xsl:param name="bottom_param"></xsl:param>
	
	<xsl:param name="lang" select="'en'"/>
	<!-- vbnet, csharp, design-->
	<xsl:param name="literals"/>
	<xsl:param name="prj_lang"></xsl:param>
	<xsl:param name="cssFileName" select="'stylesheet.css'"/>
	<xsl:param name="viewType" select="'diagram'"/>
	<xsl:output method="html"/>
	
	<!-- define keys -->
	<xsl:key name="classifier" match="//Classifier" use="@id"/>
	<xsl:key name="all-by-id" match="//Classifier | //DesignElement | //Package | //Method | //Field | //Parameter | //Diagram" use="@id"/>
	<xsl:key name="diagram-metaclass" match="Diagram" use="@metaclass" />
	<xsl:key name="mprop" match="Property" use="@name" />
	<xsl:key name="reference-metaclass" match="DiagramReference" use="@metaclass"/>
	<xsl:key name="links-metaclasses" match="Link/@metaclass" use="'all'"/>
	
	<!-- include stylesheets -->
	<xsl:include href="hyperlinks.xsl"></xsl:include>
	<xsl:include href="use/use_table.xsl"></xsl:include>
	<xsl:include href="use/class_use.xsl"></xsl:include>
	<xsl:include href="navbar/class_use_navbar.xsl"></xsl:include>

	<xsl:include href="tree/common.xsl"></xsl:include>
	<xsl:include href="tree/overview_tree.xsl"></xsl:include>
	<xsl:include href="tree/package_tree.xsl"></xsl:include>
	<xsl:include href="navbar/common_navbar.xsl"></xsl:include>
	<xsl:include href="navbar/overview_tree_navbar.xsl"></xsl:include>
	<xsl:include href="navbar/package_tree_navbar.xsl"></xsl:include>
	
	<xsl:include href="summary/inner_class_summary.xsl"></xsl:include>
	<xsl:include href="overview_frame.xsl"></xsl:include>
	<xsl:include href="package_frame.xsl"></xsl:include>
	<xsl:include href="allclasses_frame.xsl"></xsl:include>
	<xsl:include href="navbar/class_navbar.xsl"></xsl:include>
	<xsl:include href="navbar/index_navbar.xsl"></xsl:include>
	<xsl:include href="navbar/diagram_navbar.xsl"></xsl:include>
	<xsl:include href="navbar/package_navbar.xsl"></xsl:include>
	<xsl:include href="navbar/help_navbar.xsl"></xsl:include>
	<xsl:include href="navbar/overview_navbar.xsl"></xsl:include>
	<xsl:include href="navbar/navbar.xsl"></xsl:include>
	<xsl:include href="help.xsl"></xsl:include>
	<xsl:include href="index_all.xsl"></xsl:include>
	<xsl:include href="util/util.xsl"></xsl:include>
	<xsl:include href="links.xsl"></xsl:include>
	<xsl:include href="util/method_util.xsl"></xsl:include>
	<xsl:include href="detail/method_detail.xsl"></xsl:include>
	<xsl:include href="summary/method_summary.xsl"></xsl:include>
	<xsl:include href="detail/constructor_detail.xsl"></xsl:include>
	<xsl:include href="detail/destructor_detail.xsl"></xsl:include>
	<xsl:include href="summary/constructor_summary.xsl"></xsl:include>
	<xsl:include href="summary/destructor_summary.xsl"></xsl:include>
	<xsl:include href="summary/field_summary.xsl"></xsl:include>
	<xsl:include href="detail/field_detail.xsl"></xsl:include>
	<xsl:include href="util/class_util.xsl"></xsl:include>
	<xsl:include href="class.xsl"></xsl:include>
	<xsl:include href="package.xsl"></xsl:include>
	<xsl:include href="diagram.xsl"></xsl:include>
	<xsl:include href="util/design_util.xsl"></xsl:include>
  <xsl:include href="util/lang_util.xsl"></xsl:include>
	
	<msxsl:script language="CSharp" implements-prefix="rpr">
		<![CDATA[
		System.String prefix="";
	
		public System.String GetRelativePrefix() {
			return prefix;
		}
		public System.String SetRelativePrefix(System.String value) {
			System.String res = prefix;
			prefix = value;
			return res;
		}
		]]>
	</msxsl:script>
	
	<xsl:template name="SetFilePrefix">
		<xsl:param name="path"/>
				
		<xsl:variable name="prefix">
			<xsl:call-template name="RelativePrefix">
				<xsl:with-param name="path" select="substring-after($path, concat($outdir, '/'))"/>
				<xsl:with-param name="prefix" select="''"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:value-of select="rpr:SetRelativePrefix($prefix)"/>
	</xsl:template>
	
	<xsl:template name="ResetPrefix">
		<xsl:param name="prefix"/>
		<xsl:value-of select="rpr:SetRelativePrefix($prefix)"/>
	</xsl:template>
	
	<xsl:template name="GetCurrentPrefix">
		<xsl:value-of select="rpr:GetRelativePrefix()"/>
	</xsl:template>
	
	
	<!-- Package Summary template -->
	<xsl:template match="/">
		<xsl:call-template name="createIndex"/>
		<xsl:call-template name="createAllClassesFrame"/>

		<xsl:if test="$index_param">
			<xsl:call-template name="createIndexAll"/>
		</xsl:if>
		
		<xsl:call-template name="createOverviewFrame"/>

		<xsl:if test="$tree_param">
			<xsl:call-template name="createOverViewTree"/>	
		</xsl:if>
		
		<xsl:if test="$help_param">
			<xsl:call-template name="createHelpDoc"/>
		</xsl:if>
		
		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/overview-summary.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<xsl:variable name="packages" select="//Package"/>
			<exsl:document href="file:///{$outdir}/overview-summary.html">
				<html>
				<head>
			<xsl:call-template name="ImportCSS"/>
				<title>
				<xsl:value-of select="$title_param"></xsl:value-of>
				</title>
				<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
				<xsl:call-template name="ImgLoaderScript"/>
				</head>

				<!-- NAVBAR -->
				<xsl:if test="$navbar_param">
					<xsl:call-template name="OverViewNavBar">
						<xsl:with-param name="header" select="'true'"></xsl:with-param>
					</xsl:call-template>
				</xsl:if>
				<br/>
				<hr/>
				
				<xsl:if test="$doctitle_param">
				  <center><h2>
				    <xsl:value-of select="$doctitle_param"></xsl:value-of>
				  </h2></center>
				</xsl:if>

			  <h2>
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'Project'"></xsl:with-param>
					<xsl:with-param name="p1" select="Model/@name"></xsl:with-param>
				</xsl:call-template>
			  </h2>
				
				<xsl:variable name="packs">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'packages'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>				
			
			<xsl:if test="not(count($packages)=0)" >
				<xsl:call-template name="createSummaryTable">
					<xsl:with-param name="title" select="$packs"/>
					<xsl:with-param name="nodeSet" select="$packages"/>
				</xsl:call-template>
			</xsl:if>
			
			<!--all diagrams summary-->
			<xsl:variable name="diagrams" select="Model//Diagram"></xsl:variable>
			<xsl:if test="not(count($diagrams)=0)" >
				<xsl:variable name="diags">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'diagrams'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:call-template name="allElementSummaryTable">
					<xsl:with-param name="title" select="$diags"/>
					<xsl:with-param name="nodeSet" select="$diagrams"/>
					<!--xsl:with-param name="packagePath" select="$outdir"/-->
				</xsl:call-template>
			</xsl:if>
			
			<!--all classes summary-->
			<xsl:variable name="classes" select="Model/Classifier[not(@type='Interface')] | Model//Classifier[not(@type='Interface')]"></xsl:variable>
			<xsl:if test="not(count($classes)=0)">
				<xsl:variable name="clss">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'classes'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>				
				<xsl:call-template name="allElementSummaryTable">
					<xsl:with-param name="title" select="$clss"/>
					<xsl:with-param name="nodeSet" select="$classes"/>
				</xsl:call-template>
			</xsl:if>
			
			<!--all interfaces summary-->
			<xsl:variable name="interfaces" select="Model/Classifier[@type='Interface'] | Model//Classifier[@type='Interface']"></xsl:variable>
			<xsl:if test="not(count($interfaces)=0)">
				<xsl:variable name="iface">
					<xsl:call-template name="getLocalizedResource">
						<xsl:with-param name="code" select="'interfaces'"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>				
				<xsl:call-template name="allElementSummaryTable">
					<xsl:with-param name="title" select="$iface"/>
					<xsl:with-param name="nodeSet" select="$interfaces"/>
					<xsl:with-param name="italikStyle" select="'true'"/>
				</xsl:call-template>
			</xsl:if>
			
				<hr/>
				<!-- NAVBAR -->
				<xsl:if test="$navbar_param">
					<xsl:call-template name="OverViewNavBar"></xsl:call-template>
				</xsl:if>
				<br/>
				<xsl:value-of select="$bottom_param"></xsl:value-of>
				</html>
				
			</exsl:document>
			<xsl:variable name="tmp">
				<xsl:call-template name="ResetPrefix">
					<xsl:with-param name="prefix" select="$prevPrefix"/>
				</xsl:call-template>
			</xsl:variable>
		<xsl:apply-templates/>
	</xsl:template>
	
	<xsl:template name="allElementSummaryTable">
		<xsl:param name="title"></xsl:param>
		<xsl:param name="nodeSet"></xsl:param>
		<xsl:param name="italikStyle"></xsl:param>
		
		<table border="1" cellpadding="3" cellspacing="0" width="100%">
			<tr class="TableHeaderStyle">
				<td colspan="2">
					<font size="+2">
						<b>
							<xsl:value-of select="$title"/>
						</b>
					</font>
				</td>
			</tr>
		
		<xsl:for-each select="$nodeSet">
			<tr class="TableRow">
				<td width="15%">
			<b>
			<xsl:variable name="ref">
				<xsl:apply-templates select="current()" mode="getRelativePath"/>
			</xsl:variable>
			
			<xsl:apply-templates select="current()" mode="HRefWithImgLoad">
				<xsl:with-param name="isName" select="'1'"/>
			</xsl:apply-templates>
						</b>
					</td>
			</tr>
			</xsl:for-each>
		</table>
		<xsl:text>&#xA0;</xsl:text>
		
	</xsl:template>
	
	<!-- Package template -->
	<xsl:template match="//Package | //Model">
		<xsl:call-template name="packagedoc"/>
	</xsl:template>
	
	<!-- Create index.html file -->
	<xsl:template name="createIndex">
		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/index.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$outdir}/index.html">
			<xsl:variable name="currPrefix">
				<xsl:call-template name="GetCurrentPrefix"/>
			</xsl:variable>
			<html>
			<head>
			<xsl:call-template name="ImportCSS"/>
			<title>
			<xsl:value-of select="$title_param"></xsl:value-of>
			</title>
			<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			</head>
			<xsl:variable name="defDiagram">
				<xsl:call-template name="defaultDiagram"></xsl:call-template>
			</xsl:variable>
			<xsl:variable name="classFramePath">
				<xsl:call-template name="HandleClassFrameStartPath"></xsl:call-template>
			</xsl:variable>
			
			<xsl:choose>
				<xsl:when test="$navigation">
					<script language="JavaScript">
				    var isAppletFirstTime = true;
					</script>
					<xsl:choose>
						<xsl:when test="$images">
							<frameset rows="50%,*">
								<frame src="{$defDiagram}" name="imageFrame"/>
								<frameset cols="25%,*">
									<frame src="overview-frame.html" name="packageListFrame" scrolling="no" />
									<frame src="{$classFramePath}" name="classFrame"/>
								</frameset>
							</frameset>
						</xsl:when>
						<xsl:otherwise>
							<frameset cols="20%,*">
								<frame src="overview-frame.html" name="packageListFrame" scrolling="no" />
								<frame src="{$classFramePath}" name="classFrame"/>
							</frameset>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:when>
				<xsl:otherwise>
					<frameset cols="20%,*">
						<frameset rows="30%,*">
							<frame src="overview-frame.html" name="packageListFrame" scrolling="auto"/>
							<frame src="allclasses-frame.html" name="packageFrame" scrolling="auto"/>
						</frameset>
						<xsl:choose>
							<xsl:when test="$images">
								<frameset rows="50%,*">
									<frame src="{$defDiagram}" name="imageFrame" scrolling="auto"/>
									<frame src="{$classFramePath}" name="classFrame" scrolling="auto"/>
								</frameset>
							</xsl:when>
							<xsl:otherwise>
								<frame src="{$classFramePath}" name="classFrame" scrolling="auto"/>
							</xsl:otherwise>
						</xsl:choose>
						</frameset>
				</xsl:otherwise>
			</xsl:choose>			
			
			<noframes>
				<h2> Frame Alert</h2>
				<p/> This document is designed to be viewed using the frames feature. If you see this message, you are using a non-frame-capable web client.<br/> Link to<a href=".//package-summary.html">Non-frame version.</a>
			</noframes>
			</html>
			
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix"/>
			</xsl:call-template>
		</xsl:variable>
	</xsl:template>
	
	<!-- Create all classes frame -->
	<xsl:template name="createAllClassesFrame">
		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/allclasses-frame.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$outdir}/allclasses-frame.html">
			<head>
			<xsl:call-template name="ImportCSS"/>
			<title>
			<xsl:value-of select="$title_param"></xsl:value-of>
			</title>
			<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			<xsl:call-template name="ImgLoaderScript"/>
			</head>
			<xsl:call-template name="allClasses-frame">
			</xsl:call-template>
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix"/>
			</xsl:call-template>
		</xsl:variable>
	</xsl:template>

	<!-- Create index-all.html -->
	<xsl:template name="createIndexAll">

		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/index-all.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$outdir}/index-all.html">
			<head>
			<xsl:call-template name="ImportCSS"/>
			<title>
			<xsl:value-of select="$title_param"></xsl:value-of>
			</title>
			<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			<xsl:call-template name="ImgLoaderScript"/>
			</head>
			<body>
<!--
			<xsl:variable name="literals">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'index_abc'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
-->

			<!-- NAVBAR -->
			<xsl:if test="$navbar_param">
				<xsl:call-template name="IndexNavBar">
					<xsl:with-param name="header" select="'true'"></xsl:with-param>
				</xsl:call-template>
			</xsl:if>
			<xsl:call-template name="IndexList">
				<xsl:with-param name="abc" select="$literals"></xsl:with-param>
			</xsl:call-template>	
				
			<hr/>
	
			<xsl:call-template name="ProcessXML">
				<xsl:with-param name="abc" select="$literals"></xsl:with-param>
			</xsl:call-template>	

			<!-- NAVBAR -->
			<hr/>
			<xsl:if test="$navbar_param">
				<xsl:call-template name="IndexNavBar"></xsl:call-template>
			</xsl:if>
				
			<xsl:call-template name="IndexList">
				<xsl:with-param name="abc" select="$literals"></xsl:with-param>
			</xsl:call-template>	
			<br/>
			<p/>
			<xsl:value-of select="$bottom_param"></xsl:value-of>
			</body>
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix"/>
			</xsl:call-template>
		</xsl:variable>
	</xsl:template>

	<!-- Create overview-tree.html file -->
	<xsl:template name="createOverViewTree">
		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/overview-tree.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$outdir}/overview-tree.html">
			<head>
			<xsl:call-template name="ImportCSS"/>
			<title>
			<xsl:value-of select="$title_param"></xsl:value-of>
			</title>
			<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			<xsl:call-template name="ImgLoaderScript"/>
			</head>
			<xsl:call-template name="OverViewTree">
			</xsl:call-template>
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix"/>
			</xsl:call-template>
		</xsl:variable>
	</xsl:template>		
	
	<!-- Create overview-frame.html file -->
	<xsl:template name="createOverviewFrame">
		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/overview-frame.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$outdir}/overview-frame.html">
			<head>
			<xsl:call-template name="ImportCSS"/>
				<title>
				<xsl:value-of select="$title_param"></xsl:value-of>
				<xsl:text> Overview </xsl:text>
				</title>
			<xsl:call-template name="ImgLoaderScript"/>
			<script  language="javascript">
				function reload(){
					try{
						if (parent.imageFrame == null){
							return;
						}
						parent.imageFrame.loadImage();
					}catch(Exception){
					}
				}
			</script>
			<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			</head>
			<xsl:variable name="project_tab">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'project_tab'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:variable name="overview_tab">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'overview_tab'"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$navigation">
					<!-- Create navigation applet-->
					<body onload="reload()" topmargin='0' leftmargin='0' rightmargin='0' bottommargin='0' marginheight='0' marginwidth='0'>
						<applet archive="navigation.jar" code="navigation.Navigation.class" name="navigApplet" width="100%" height="100%" MAYSCRIPT="">
							<param  name="ModelTab" value="{$project_tab}"/>
							<param name="ModelFile" value="model-tree/model.tree"/>
							<xsl:if test="$images">
								<param name='ViewTab' value='{$overview_tab}'/>
							</xsl:if>
						</applet>
					</body>
				</xsl:when>
				<xsl:otherwise>
					<!-- Create overview frame-->
					<xsl:call-template name="OverviewFrame"></xsl:call-template>
					<xsl:variable name="packages" select="//Package | //Model"/>
					<xsl:for-each select="$packages">
						<xsl:variable name="packPath">
							<xsl:call-template name="PackageFramePath">
								<xsl:with-param name="element" select="current()"></xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:variable name="prevPrefix2">
							<xsl:call-template name="SetFilePrefix">
								<xsl:with-param name="path" select="concat($outdir, '/', $packPath)"/>
							</xsl:call-template>
						</xsl:variable>
						<exsl:document href="file:///{$outdir}/{$packPath}">
							<xsl:call-template name="PackageFrame">
								<xsl:with-param name="package" select="current()"></xsl:with-param>
							</xsl:call-template>
						</exsl:document>
						<xsl:variable name="tmp">
							<xsl:call-template name="ResetPrefix">
								<xsl:with-param name="prefix" select="$prevPrefix2"/>
							</xsl:call-template>
						</xsl:variable>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix"/>
			</xsl:call-template>
		</xsl:variable>

	</xsl:template>

	<!-- Create help doc file -->
	<xsl:template name="createHelpDoc">
		<xsl:variable name="prevPrefix">
			<xsl:call-template name="SetFilePrefix">
				<xsl:with-param name="path" select="concat($outdir, '/help-doc.html')"/>
			</xsl:call-template>
		</xsl:variable>
		<exsl:document href="file:///{$outdir}/help-doc.html">
			<head>
			<xsl:call-template name="ImportCSS"/>
				<title>Help</title>
				<xsl:text disable-output-escaping="yes">&lt;meta http-equiv="Content-Type" content="text/html; charset=UTF-8"&gt;</xsl:text>
			</head>
			<body>
				<xsl:call-template name="CreateHelpDoc"></xsl:call-template>
			</body>
		</exsl:document>
		<xsl:variable name="tmp">
			<xsl:call-template name="ResetPrefix">
				<xsl:with-param name="prefix" select="$prevPrefix"/>
			</xsl:call-template>
		</xsl:variable>
	</xsl:template>


	<!-- Counts default diagram name -->
	<xsl:template name="defaultDiagram">
	<xsl:choose>
		<xsl:when test="$scope_param='diagram'">
			<xsl:variable name="context" select="//Diagram[@name=$root_element_name_param][1]"></xsl:variable>
			<xsl:variable name="path">
				<xsl:call-template name="DiagramMapPath">
					<xsl:with-param name="element" select="$context"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$path">
					<xsl:value-of select="$path"></xsl:value-of>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>about:blank</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:when>
		<xsl:otherwise>
			<xsl:variable name="defDiagrams" select="//Model[@name=$root_element_name_param]/Diagram/Property[@name='defaultDiagram']/.. | //Package[@name=$root_element_name_param]/Diagram/Property[@name='defaultDiagram']/.."></xsl:variable>
			<xsl:variable name="defdiagram" select="$defDiagrams[1]"></xsl:variable>
			<xsl:variable name="path">
				<xsl:call-template name="DiagramMapPath">
					<xsl:with-param name="element" select="$defdiagram"></xsl:with-param>
				</xsl:call-template>
			</xsl:variable>
			<xsl:choose>
				<xsl:when test="$path">
					<xsl:value-of select="$path"></xsl:value-of>
				</xsl:when>
				<xsl:otherwise>
					<xsl:text>about:blank</xsl:text>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:otherwise>
	</xsl:choose>
	</xsl:template>

	
	<!-- Access to resource strings -->
	<xsl:template name="getLocalizedResource">
		<xsl:param name="code" />
		<xsl:param name="p1" />
		<xsl:param name="p2" />
		<xsl:param name="p3" />
		<xsl:param name="p4" />
		<xsl:variable name="message-file">
			<xsl:choose>
				<xsl:when test="($prj_lang='design') or ($prj_lang='delphi')">
					<xsl:value-of select="concat('messages.', $prj_lang, '.', $lang, '.xml')"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat('messages.', $lang, '.xml')"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable> 
		<xsl:variable name="messages" select="document($message-file)/messages"/>
		<xsl:variable name="unparsedString" select="$messages/message[@id=$code]"></xsl:variable>
		<xsl:choose>
			<xsl:when test="contains($unparsedString, '{0}')">
				<xsl:variable name="first">
					<xsl:call-template name="replace">
						<xsl:with-param name="source" select="$unparsedString"></xsl:with-param>
						<xsl:with-param name="what" select="'{0}'"></xsl:with-param>
						<xsl:with-param name="with" select="$p1"></xsl:with-param>
					</xsl:call-template>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="contains($first, '{1}')">
						<xsl:variable name="second">
							<xsl:call-template name="replace">
								<xsl:with-param name="source" select="$first"></xsl:with-param>
								<xsl:with-param name="what" select="'{1}'"></xsl:with-param>
								<xsl:with-param name="with" select="$p2"></xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="contains($second, '{2}')">
								<xsl:variable name="third">
									<xsl:call-template name="replace">
										<xsl:with-param name="source" select="$second"></xsl:with-param>
										<xsl:with-param name="what" select="'{2}'"></xsl:with-param>
										<xsl:with-param name="with" select="$p3"></xsl:with-param>
									</xsl:call-template>
								</xsl:variable>
								<xsl:choose>
									<xsl:when test="contains($third, '{3}')">
										<xsl:variable name="fourth">
											<xsl:call-template name="replace">
												<xsl:with-param name="source" select="$third"></xsl:with-param>
												<xsl:with-param name="what" select="'{3}'"></xsl:with-param>
												<xsl:with-param name="with" select="$p4"></xsl:with-param>
											</xsl:call-template>
										</xsl:variable>
										<xsl:value-of select="$fourth"></xsl:value-of>										
									</xsl:when>
									<xsl:otherwise>
										<xsl:value-of select="$third"></xsl:value-of>
									</xsl:otherwise>
								</xsl:choose>								
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="$second"></xsl:value-of>
							</xsl:otherwise>
						</xsl:choose>						
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="$first"></xsl:value-of>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$unparsedString"></xsl:value-of>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template name="HandleClassFrameStartPath">
		<!--xsl:choose>
			<xsl:when test="$scope_param='diagram'">
				<xsl:variable name="diagrams" select="//Diagram[@name=$root_element_name_param][1]"></xsl:variable>
				<xsl:for-each select="$diagrams">
					<xsl:if test="position()=1">
						<xsl:variable name="path">
							<xsl:call-template name="pathResolver">
								<xsl:with-param name="element" select="current()"></xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$path">
								<xsl:value-of select="$path"></xsl:value-of>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>about:blank</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="$scope_param='package'">
				<xsl:variable name="packages" select="//Model[@name=$root_element_name_param] | //Package[@name=$root_element_name_param]"></xsl:variable>
				<xsl:for-each select="$packages">
					<xsl:if test="position()=1">
						<xsl:variable name="path">
							<xsl:call-template name="pathResolver">
								<xsl:with-param name="element" select="current()"></xsl:with-param>
							</xsl:call-template>
						</xsl:variable>
						<xsl:choose>
							<xsl:when test="$path">
								<xsl:value-of select="$path"></xsl:value-of>
							</xsl:when>
							<xsl:otherwise>
								<xsl:text>about:blank</xsl:text>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:if>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise-->
				<xsl:value-of select="'overview-summary.html'"></xsl:value-of>			
			<!--/xsl:otherwise>
		</xsl:choose-->
	</xsl:template>
	
	<!-- Replaces substring of source string -->
	<xsl:template name="replace">
		<xsl:param name="source"></xsl:param>
		<xsl:param name="what"></xsl:param>
		<xsl:param name="with"></xsl:param>
		<xsl:choose>
			<xsl:when test="contains($source, $what)">
				<xsl:variable name="result" select="concat(substring-before($source, $what), $with, substring-after($source, $what))"></xsl:variable>
				<xsl:call-template name="replace">
					<xsl:with-param name="source" select="$result"></xsl:with-param>					
					<xsl:with-param name="what" select="$what"></xsl:with-param>
					<xsl:with-param name="with" select="$with"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$source"></xsl:value-of>				
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
</xsl:stylesheet>
